/*
	This is a part of the source code for Pro/DESKTOP.
	Copyright (C) 1998-1999 Parametric Technology Corporation.
	All rights reserved.
*/

//	TranslateObjects.cpp

#include <stdafx.h>

#include "CUtility.h"
#include "CEdit.h"
#include "CApplication.h"

HRESULT TranslateObjects(double xDistance, double yDistance, ISet *objectSet1)
{

//	Translates the object set with the given xDistance and yDistance
//	and returns the translated object set

	START_METHOD("TranslateObjects")

	HRESULT status = CONV_SUCCESS;

	IGraphicDocument *activeGraphicDoc = NULL;
	IPartDocument *activePart = NULL;
	IWorkplane *activeWorkplane = NULL;
	ISketch *activeSketch = NULL;

	status = GetActivePartWorkplaneSketch(&activePart, &activeGraphicDoc, &activeWorkplane, &activeSketch);
	CHECK_RETURN_STATUS(status)

	// Get the translation vector
	IVector *transVector1 = NULL;
	status = (GetCLASS(Vector))->CreateVector(xDistance, yDistance, 0, &transVector1);
	CHECK_RETURN_STATUS(status)

	// Get local origin
	IVector *localOrigin = NULL;
	status = activeWorkplane->GetLocalOrigin(&localOrigin);
	CHECK_RETURN_STATUS(status)

	IVector *vector2 = NULL;
	status = activeWorkplane->Get3DVector(transVector1, &vector2);
	CHECK_RETURN_STATUS(status)

	IVector *transVector = NULL;
	status = vector2->subtract(CAST(IVectorOrDirection, localOrigin), &transVector);
	CHECK_RETURN_STATUS(status)

	// Create the translation matrix
	IMatrix *transMatrix = NULL;
	status = (GetCLASS(Matrix))->CreateTranslationMatrix(transVector, &transMatrix);
	CHECK_RETURN_STATUS(status)

	// Transform the objects
	status = activeWorkplane->TransformObjects(CAST(IObjectOrSet, objectSet1), transMatrix);
	CHECK_RETURN_STATUS(status)

	END_METHOD("TranslateObjects")
}
